/*** 1.   ũƮ ***/

SELECT a.seq
, a.seq%7 AS no1
, a.seq%13 AS no2 INTO TB_Subupdate
FROM (SELECT ROW_NUMBER() OVER (ORDER BY a.number) AS seq
	 FROM master..spt_values a
	 JOIN master..spt_values b
	 ON a.type = 'P' AND b.type = 'P' 
	 AND a.number BETWEEN 1 AND 100 AND b.number BETWEEN 1 AND 10
) a

SELECT a.seq
	, DATEPART(YY, DATEADD(YY, -b.number%100, '2020-09-10 00:00:00.000')) AS year
	, low AS no1
	, high AS no2 INTO TB_Sublist
FROM TB_Subupdate a, master..spt_values b
WHERE b.type = 'P' and b.number BETWEEN 100 AND 110

CREATE CLUSTERED INDEX CIDX_Subupdate ON TB_Subupdate (seq)
CREATE CLUSTERED INDEX CIDX_Sublist ON TB_Sublist(year, seq)
GO


/*** 2. [AS-IS] SQL    ȹ ***/

UPDATE TB_Subupdate 
SET no1=(SELECT no1 FROM TB_Sublist b WHERE b.seq=a.seq AND year = 2019), 
	no2=(SELECT no2 FROM TB_Sublist b WHERE b.seq=a.seq AND year = 2019)
FROM TB_Subupdate a
GO


/*** 6. [TO-BE]   ***/

UPDATE a
SET no1 = b.no1
	,no2 = b.no2
FROM TB_Subupdate a 
LEFT OUTER JOIN TB_Sublist b 
ON a.seq=b.seq
WHERE b.year = 2019
GO